<?php
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license https://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/index.php?alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */
    
    session_start();
    include "../../include/costanti.php";
    include "../../include/util.php";
    include "../../gUtil/DbManager.php";

    if(!isset($_SESSION["geecomAdmin_email"])) {
        header("Location: index.php");
    }
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);
    $datiGeecomCms = $geecomDb->leggiSingolaRiga("geec_prodotti",1);
    
    $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_ADD_SLASHES);

    switch($operazione) {
        case 'aggiornaMetodiPagamento':
            $nomeEstrattoConto         = filter_input(INPUT_POST,"nomeEstrattoConto",FILTER_SANITIZE_ADD_SLASHES);
            $attivaPagamentoConsegna   = filter_input(INPUT_POST,"attivaPagamentoConsegna",FILTER_SANITIZE_ADD_SLASHES);
            $dettagliPagamentoConsegna = filter_input(INPUT_POST,"dettagliPagamentoConsegna",FILTER_SANITIZE_ADD_SLASHES);
            $costoPagamentoConsegna    = filter_input(INPUT_POST,"costoPagamentoConsegna",FILTER_SANITIZE_ADD_SLASHES);
            $attivaPaypal              = filter_input(INPUT_POST,"attivaPaypal",FILTER_SANITIZE_ADD_SLASHES);
            $attivaPaypalCartaDiCredito= filter_input(INPUT_POST,"attivaPaypalCartaDiCredito",FILTER_SANITIZE_ADD_SLASHES);
            $attivaPagamento3Rate      = filter_input(INPUT_POST,"attivaPagamento3Rate",FILTER_SANITIZE_ADD_SLASHES);
            $importoMinimoPagamento3Rate = filter_input(INPUT_POST,"importoMinimoPagamento3Rate",FILTER_SANITIZE_ADD_SLASHES);
            $sandboxPaypal             = filter_input(INPUT_POST,"sandboxPaypal",FILTER_SANITIZE_ADD_SLASHES);
            $clientIdPaypal            = filter_input(INPUT_POST,"clientIdPaypal",FILTER_SANITIZE_ADD_SLASHES);
            $secretPaypal              = filter_input(INPUT_POST,"secretPaypal",FILTER_SANITIZE_ADD_SLASHES);
            $attivaStripe              = filter_input(INPUT_POST,"attivaStripe",FILTER_SANITIZE_ADD_SLASHES);
            $idAccountStripe           = $_POST["idAccountStripe"];
            $chiavePubblicaStripe      = filter_input(INPUT_POST,"chiavePubblicaStripe",FILTER_SANITIZE_ADD_SLASHES);
            $chiaveSegretaStripe       = filter_input(INPUT_POST,"chiaveSegretaStripe",FILTER_SANITIZE_ADD_SLASHES);
            $attivaSatispay            = filter_input(INPUT_POST,"attivaSatispay",FILTER_SANITIZE_ADD_SLASHES);
            $idAccountSatispay         = filter_input(INPUT_POST,"idAccountSatispay",FILTER_SANITIZE_ADD_SLASHES);
            $chiavePubblicaSatispay    = filter_input(INPUT_POST,"chiavePubblicaSatispay",FILTER_SANITIZE_ADD_SLASHES);
            $chiaveSegretaSatispay     = filter_input(INPUT_POST,"chiaveSegretaSatispay",FILTER_SANITIZE_ADD_SLASHES);
            $attivaConto               = filter_input(INPUT_POST,"attivaContoCorrente",FILTER_SANITIZE_ADD_SLASHES);
            $dettagliContoCorrente     = filter_input(INPUT_POST,"dettagliContoCorrente",FILTER_SANITIZE_ADD_SLASHES);
            $attivaPrepagata           = filter_input(INPUT_POST,"attivaPrepagata",FILTER_SANITIZE_ADD_SLASHES);
            $dettagliPrepagata         = filter_input(INPUT_POST,"dettagliPrepagata",FILTER_SANITIZE_ADD_SLASHES);

            $queryAggiornamento = "UPDATE geecEc_impostazioniPagamenti SET nomeEstrattoConto='$nomeEstrattoConto', attivaPagamentoConsegna='$attivaPagamentoConsegna', dettagliPagamentoConsegna='$dettagliPagamentoConsegna', costoPagamentoConsegna = '$costoPagamentoConsegna', attivaPaypal='$attivaPaypal', attivaPagamento3Rate='$attivaPagamento3Rate', importoMinimoPagamento3Rate='$importoMinimoPagamento3Rate', sandboxPaypal='$sandboxPaypal', clientIdPaypal='$clientIdPaypal', secretPaypal='$secretPaypal', attivaPaypalCartaDiCredito='$attivaPaypalCartaDiCredito', attivaStripe='$attivaStripe', chiavePubblicaStripe='$chiavePubblicaStripe', idAccountStripe='$idAccountStripe', chiavePubblicaStripe='$chiavePubblicaStripe', chiaveSegretaStripe='$chiaveSegretaStripe', attivaSatispay='$attivaSatispay', idAccountSatispay='$idAccountSatispay', chiavePubblicaSatispay='$chiavePubblicaSatispay', chiaveSegretaSatispay='$chiaveSegretaSatispay', attivaContoCorrente='$attivaConto', dettagliContoCorrente='$dettagliContoCorrente', attivaPrepagata='$attivaPrepagata', dettagliPrepagata='$dettagliPrepagata' WHERE id=1";
            $geecomDb->eseguiQueryLettura($queryAggiornamento);
            header("Location: ../../".str_replace("../","",$datiGeecomCms["percorso"])."/componenti/ecommerce/index.php?status=260");
            break;
        case 'modificaImpostazioniGenerali':
            $bloccaAcquisti            = filter_input(INPUT_POST,"bloccaAcquisti",FILTER_SANITIZE_ADD_SLASHES);
            $mailOrdini		       = filter_input(INPUT_POST,"mailOrdini",FILTER_SANITIZE_ADD_SLASHES);
            $posizioneBarraLaterale    = filter_input(INPUT_POST,"posizioneBarraLaterale",FILTER_SANITIZE_ADD_SLASHES);
            $registrazioneObbligatoria = filter_input(INPUT_POST,"registrazioneObbligatoria",FILTER_SANITIZE_ADD_SLASHES);
            $richiediPassword          = filter_input(INPUT_POST,"richiediPassword",FILTER_SANITIZE_ADD_SLASHES);
            $mostraSelettoreQuantita   = filter_input(INPUT_POST,"mostraSelettoreQuantita",FILTER_SANITIZE_ADD_SLASHES);
            $mostraPezziRimanenti      = filter_input(INPUT_POST,"mostraPezziRimanenti",FILTER_SANITIZE_ADD_SLASHES);
            $mostraEanPaginaProdotto   = filter_input(INPUT_POST,"mostraEanPaginaProdotto",FILTER_SANITIZE_ADD_SLASHES);
            $paginaAcquistoNonEffettuato = filter_input(INPUT_POST,"paginaAcquistoNonEffettuato",FILTER_SANITIZE_ADD_SLASHES);

            $attivaRaccomandazioneProdotti		= filter_input(INPUT_POST,"attivaRaccomandazioneProdotti",FILTER_SANITIZE_ADD_SLASHES);
            $numeroProdottiRaccomandatiDaMostrare	= filter_input(INPUT_POST,"numeroProdottiRaccomandatiDaMostrare",FILTER_SANITIZE_ADD_SLASHES);

            $aggiungiIvaProdotti      = filter_input(INPUT_POST,"aggiungiIvaProdotti",FILTER_SANITIZE_ADD_SLASHES);
            $valorePredefinitoIva     = filter_input(INPUT_POST,"valorePredefinitoIva",FILTER_SANITIZE_NUMBER_INT);
            $mostraIvaPrezziNegozio   = filter_input(INPUT_POST,"mostraIvaPrezziNegozio",FILTER_SANITIZE_ADD_SLASHES);
            $mostraIvaPrezziCarrello  = filter_input(INPUT_POST,"mostraIvaPrezziCarrello",FILTER_SANITIZE_ADD_SLASHES);
                        
            $documentoFiscale          = filter_input(INPUT_POST,"documentoFiscale",FILTER_SANITIZE_ADD_SLASHES);
            $prefissoDocumentoFiscale  = filter_input(INPUT_POST,"prefissoDocumentoFiscale",FILTER_SANITIZE_ADD_SLASHES);
            
            $nascondiDivSpedizione = $geecomDb->escapeString($_POST["nascondiDivSpedizione"]);

            $queryAggiornamento = "UPDATE geecEc_impostazioni SET posizioneBarraLaterale='$posizioneBarraLaterale', bloccaAcquisti='$bloccaAcquisti', mailOrdini='$mailOrdini', registrazioneObbligatoria='$registrazioneObbligatoria', richiediPassword='$richiediPassword', attivaRaccomandazioneProdotti = '$attivaRaccomandazioneProdotti', numeroProdottiRaccomandatiDaMostrare='$numeroProdottiRaccomandatiDaMostrare', mostraSelettoreQuantita='$mostraSelettoreQuantita', mostraPezziRimanenti='$mostraPezziRimanenti', mostraEanPaginaProdotto='$mostraEanPaginaProdotto', paginaAcquistoNonEffettuato='$paginaAcquistoNonEffettuato', aggiungiIvaProdotti='$aggiungiIvaProdotti', valorePredefinitoIva='$valorePredefinitoIva',  mostraIvaPrezziNegozio='$mostraIvaPrezziNegozio', mostraIvaPrezziCarrello='$mostraIvaPrezziCarrello', documentoFiscale='$documentoFiscale', prefissoDocumentoFiscale='$prefissoDocumentoFiscale',  nascondiDivSpedizione='$nascondiDivSpedizione' WHERE id=1";
            $geecomDb->eseguiQueryLettura($queryAggiornamento);
            header("Location: ../../".str_replace("../","",$datiGeecomCms["percorso"])."/componenti/ecommerce/index.php?status=270");
            break;
        case 'modificaPercentualeScontoGruppo':
            $idGruppo          = filter_input(INPUT_POST,"idGruppo",FILTER_SANITIZE_NUMBER_INT);
            $percentualeSconto = filter_input(INPUT_POST,"percentualeSconto",FILTER_SANITIZE_NUMBER_INT);
            
            $queryAggiornamento = "UPDATE geec_gruppi SET percentualeSconto='$percentualeSconto' WHERE id=$idGruppo";
            $geecomDb->eseguiQueryLettura($queryAggiornamento);
            echo "ok";
            break;
        case 'modificaIncentiviAcquisto':
            $messaggioPulsanteCarrelloPaginaProdotti = filter_input(INPUT_POST,"messaggioPulsanteCarrelloPaginaProdotti",FILTER_SANITIZE_ADD_SLASHES);
            $mostraTempoNecessarioConsegna           = filter_input(INPUT_POST,"mostraTempoNecessarioConsegna",FILTER_SANITIZE_ADD_SLASHES);
            $fraseTempoNecessarioConsegna            = filter_input(INPUT_POST,"fraseTempoNecessarioConsegna",FILTER_SANITIZE_ADD_SLASHES);
            
            $testoInAlto  = $geecomDb->escapeString($_POST["testoInAlto"]);
            $testoADestra = $geecomDb->escapeString($_POST["testoADestra"]);
            $testoInBasso = $geecomDb->escapeString($_POST["testoInBasso"]);
            
            $queryAggiornamento = "UPDATE geecEc_impostazioni SET messaggioPulsanteCarrelloPaginaProdotti='$messaggioPulsanteCarrelloPaginaProdotti', mostraTempoNecessarioConsegna='$mostraTempoNecessarioConsegna', fraseTempoNecessarioConsegna='$fraseTempoNecessarioConsegna' WHERE id=1";
            $geecomDb->eseguiQueryLettura($queryAggiornamento);

            $queryModificaImpostazioniCarrello  = "UPDATE geecEc_impostazioniPaginaCarrello SET testoInAlto='$testoInAlto', testoADestra='$testoADestra', testoInBasso='$testoInBasso' WHERE id=1";
            $geecomDb->eseguiQueryLettura($queryModificaImpostazioniCarrello);
            header("Location: ../../".str_replace("../","",$datiGeecomCms["percorso"])."/componenti/ecommerce/index.php?status=280");
            break;
    }
